let ingredientsData = [];

$(document).ready(function () {
  // Hozzávalók betöltése
  $.getJSON("json/ingredients.json", function (data) {
    ingredientsData = data;

    // Feltöltjük a modal selectet
    data.forEach(item => {
      $('#ingredientsSelect').append(new Option(item.name, item.id));
    });

    $('#ingredientsSelect').select2({
      placeholder: "Válassz hozzávalókat",
      allowClear: true,
      minimumResultsForSearch: 0,
      dropdownParent: $('#addRecipeModal'),
      width: '100%'
    });

    // Recepteket betöltjük
    $.getJSON("json/recipes.json", function (imported) {
      let stored = JSON.parse(localStorage.getItem('recipes')) || [];
      if (stored.length === 0) {
        localStorage.setItem('recipes', JSON.stringify(imported));
      }
      loadRecipes();
    });
  });

  // Új recept mentése
  $('#recipeForm').on('submit', function (e) {
    e.preventDefault();
    let title = $('#recipeTitle').val();
    let selected = $('#ingredientsSelect').val();
    let personCount = parseInt($('#personCount').val()) || 1;

    if (!selected || selected.length === 0) {
      alert("Válassz legalább egy hozzávalót!");
      return;
    }

    let recipe = {
      title: title,
      personCount: personCount,
      ingredients: selected
    };

    let recipes = JSON.parse(localStorage.getItem('recipes')) || [];
    recipes.push(recipe);
    localStorage.setItem('recipes', JSON.stringify(recipes));

    $('#recipeForm')[0].reset();
    $('#ingredientsSelect').val(null).trigger('change');
    $('#addRecipeModal').modal('hide');
    loadRecipes();
  });

  // Recept törlése
  $(document).on('click', '.delete-recipe', function () {
    let index = $(this).data('index');
    let recipes = JSON.parse(localStorage.getItem('recipes')) || [];
    recipes.splice(index, 1);
    localStorage.setItem('recipes', JSON.stringify(recipes));
    loadRecipes();
  });
});

// Recept lista kirajzolása
function loadRecipes() {
  let recipes = JSON.parse(localStorage.getItem('recipes')) || [];
  let search = $('#searchTitle').val() ? $('#searchTitle').val().toLowerCase().trim() : "";
  let filterIng = $('#filterIngredients').val() || [];

  $('#recipesContainer').empty();

  // Szűrés
  let filtered = recipes.filter(recipe => {
    if (search && !recipe.title.toLowerCase().includes(search)) return false;

    if (filterIng.length > 0) {
      // alakítsuk stringgé a recipe.ingredients elemeit
      let recipeIng = recipe.ingredients.map(id => id.toString());
      let hasAll = filterIng.every(fid => recipeIng.includes(fid.toString()));
      if (!hasAll) return false;
    }
    return true;
  });

  // Lapozás
  let start = (currentPage - 1) * recipesPerPage;
  let end = start + recipesPerPage;
  let paginated = filtered.slice(start, end);

  // Kártyák
  paginated.forEach((recipe, index) => {
    let htmlIngredients = "";
    recipe.ingredients.forEach(id => {
      let ing = ingredientsData.find(x => x.id.toString() === id.toString());
      if (ing) {
        let total = ing.perPerson * recipe.personCount;
        htmlIngredients += `<li>${ing.name}: <strong>${total} ${ing.unit}</strong> <small>(alap: ${ing.perPerson} ${ing.unit}/fő)</small></li>`;
      }
    });

    $('#recipesContainer').append(`
      <div class="recipes-grid-item">
        <div class="note-card">
          <h5>${recipe.title} (${recipe.personCount} fő)</h5>
          <ul>${htmlIngredients}</ul>
          <button class="btn btn-sm btn-danger delete-recipe" data-index="${index}">Törlés</button>
        </div>
      </div>
    `);
  });

  // Lapozó + Masonry
  renderPagination(filtered.length);
  applyMasonry();
}
