let currentPage = 1;
let recipesPerPage = 6; // oldalankénti receptek száma

function renderPagination(totalRecipes) {
  let totalPages = Math.ceil(totalRecipes / recipesPerPage);
  $('#pagination').empty();

  if (totalPages <= 1) return; // nincs szükség lapozóra

  for (let i = 1; i <= totalPages; i++) {
    $('#pagination').append(`
      <li class="page-item ${i === currentPage ? 'active' : ''}">
        <a class="page-link" href="#">${i}</a>
      </li>
    `);
  }

  $('#pagination .page-link').on('click', function (e) {
    e.preventDefault();
    currentPage = parseInt($(this).text());
    loadRecipes();
  });
}

function applyMasonry() {
  let $grid = $('#recipesContainer');

  // Először reseteljük Masonry-t
  if ($grid.data('masonry')) {
    $grid.masonry('destroy');
  }

  // Újrainicializálás
  $grid.masonry({
    itemSelector: '.recipes-grid-item',
    percentPosition: true,
    gutter: 15,
    fitWidth: true
  });
}
