(() => {
  'use strict';

  const form = document.querySelector('.needs-validation');
  if (!form) return;

  const password = form.querySelector('#password');
  const confirmPassword = form.querySelector('#confirmPassword');
  const confirmFeedback = form.querySelector('#confirmPasswordFeedback');

  form.addEventListener('submit', event => {
    event.preventDefault(); // <- Mindig megakadályozza az elküldést
    event.stopPropagation();

    const isPasswordMatch = password.value === confirmPassword.value;

    if (!form.checkValidity() || !isPasswordMatch) {
      if (!isPasswordMatch) {
        confirmPassword.classList.add('is-invalid');
        confirmFeedback.style.display = 'block';
      } else {
        confirmPassword.classList.remove('is-invalid');
        confirmFeedback.style.display = 'none';
      }
    } else {
      confirmPassword.classList.remove('is-invalid');
      confirmFeedback.style.display = 'none';

      // 💡 Ide jöhet a saját logikád pl. AJAX küldés
      console.log('Űrlap sikeresen validált!');
    }

    form.classList.add('was-validated');
  }, false);
})();

window.addEventListener("DOMContentLoaded", function () {
  // Csak ha már minden betöltődött
  if (typeof Inputmask !== "undefined") {
    Inputmask({"mask": "+36 (99) 999-9999"}).mask("#phone");
    Inputmask({"mask": "999999999"}).mask("#taj");
    Inputmask({"mask": "99999999-99999999-99999999"}).mask("#bankszamla");
  } else {
    console.error("Inputmask nincs betöltve!");
  }

  if (typeof flatpickr !== "undefined") {
    flatpickr("#dob", {
      dateFormat: "Y-m-d",
      maxDate: "today",
      locale: "hu"
    });

    flatpickr("#idopont", {
      enableTime: true,
      noCalendar: true,
      dateFormat: "H:i",
      time_24hr: true,
      locale: "hu"
    });
  } else {
    console.error("Flatpickr nincs betöltve!");
  }
});
